/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import java.util.*;
import org.apache.log4j.Logger;

import java.awt.*;
import javax.swing.*;

public class FontChooserDialog extends DefaultDialog 
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected static Logger logger = Logger.getLogger(FontChooserDialog.class);

    protected FontSelectionPanel fsp;
    protected Font font = null;

    //--- Constructor(s) ---

    public FontChooserDialog(Font font)
    {
	fsp = new FontSelectionPanel(font);
	jpMain.add(fsp, BorderLayout.CENTER);

	pack();

	try {
	    fsp.setSelectedFont(font);
	}
	catch (Exception e) {
	    logger.debug("font selection failed", e);
	}
    }

    //--- Method(s) ---

    public void apply() 
    {
	try {
	    font = fsp.getSelectedFont();
	}
	catch (FontSelectionPanel.InvalidFontException e) {
	}
    }

    public Font getSelectedFont()
    {
	return font;
    }

    public static Font showDialog(Component c, Font f)
    {
	FontChooserDialog d = new FontChooserDialog(f);
	d.setModal(true);
	d.setLocationRelativeTo(c);
	d.setVisible(true);
	return d.getSelectedFont();
    }

}


