/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import java.awt.*;
import javax.swing.*;

public class GridBagHelper {

    //--- Constant(s) ---

    public static final Insets COMPONENT_INSETS = new Insets(5, 5, 5, 5);
    public static final Insets LABEL_INSETS = new Insets(7, 5, 0, 5);
    public static final Insets PANEL_INSETS = new Insets(5, 5, 0, 5);
    public static final Insets STRING_INSETS = new Insets(5, 0, 0, 5);

    //--- Method(s) ---

    public static void add(Container p, Component c, Insets insets, boolean fill,
			   int anchor)
    {
	GridBagConstraints gbc = new GridBagConstraints();
	gbc.gridwidth = GridBagConstraints.REMAINDER;
	gbc.anchor = anchor;
	if (fill) {
	    gbc.fill = GridBagConstraints.HORIZONTAL;
	}
	gbc.insets = insets;
	gbc.weightx = 1;
	((GridBagLayout)p.getLayout()).setConstraints(c, gbc);
	p.add(c);
    }

    public static void add(Container p, Component c, Insets insets, boolean fill)
    {
	add(p, c, insets, fill, GridBagConstraints.NORTHWEST);
    }

    public static void add(Container p, Component c, boolean fill)
    {
	add(p, c, COMPONENT_INSETS, fill);
    }

    public static void add(Container p, Component c)
    {
	add(p, c, COMPONENT_INSETS, true);
    }

    public static JLabel add(Container p, String s)
    {
	JLabel l = new JLabel(s);
	add(p, l, STRING_INSETS, true);
	return l;
    }

    /**
     * Adds Component without a break.
     */
    public static void addComponent(Container p, Component c)
    {
	GridBagConstraints gbc = new GridBagConstraints();
	gbc.gridwidth = 1;
	gbc.anchor = GridBagConstraints.NORTHWEST;
	gbc.insets = COMPONENT_INSETS;
	((GridBagLayout)p.getLayout()).setConstraints(c, gbc);
	p.add(c);
    }

    /**
     * Print label a bit more south than the rest of the controls.
     */
    public static JLabel addLabel(Container p, String s)
    {
	JLabel l = new JLabel(s);
	GridBagConstraints gbc = new GridBagConstraints();
	gbc.gridwidth = 1;
	gbc.anchor = GridBagConstraints.NORTHWEST;
	gbc.insets = LABEL_INSETS;
	((GridBagLayout)p.getLayout()).setConstraints(l, gbc);
	p.add(l);

	return l;
    }
    
    public static void addPanel(Container p, Component c)
    {
	GridBagConstraints gbc = new GridBagConstraints();
	gbc.gridwidth = GridBagConstraints.REMAINDER;
	gbc.fill = GridBagConstraints.BOTH;
	gbc.insets = PANEL_INSETS;
	gbc.weightx = 1;
	gbc.weighty = 1;
	((GridBagLayout)p.getLayout()).setConstraints(c, gbc);
	p.add(c);
    }

    public static void addVerticalSpacer(Container p)
    {
	Canvas c = new Canvas();
	GridBagConstraints gbc = new GridBagConstraints();
	gbc.gridwidth = GridBagConstraints.REMAINDER;
	gbc.fill = GridBagConstraints.VERTICAL;
	gbc.weighty = 1;
	((GridBagLayout)p.getLayout()).setConstraints(c, gbc);
	p.add(c);
    }

}
