/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.event;

import xnap.XNap;
import xnap.gui.XNapFrame;

import java.awt.event.*;
import javax.swing.*;

/**
 * Erases the search text of <code>jtf</code>.
 */
public class EraseAction extends AbstractAction {
    
    protected JTextField jtf;
	
    public EraseAction(JTextField jtf) 
    {
	this.jtf = jtf;
	
	Icon icon = XNapFrame.getSmallIcon("locationbar_erase.png");
	if (icon != null) {
	    putValue(Action.SMALL_ICON, icon);
	}
	else {
	    putValue(Action.NAME, ">");
	}
	putValue(Action.SHORT_DESCRIPTION, XNap.tr("Erase the search text"));
	putValue(Action.MNEMONIC_KEY, new Integer('E'));
    }

    public EraseAction()
    {
	this(null);
    }
    
    public void actionPerformed(ActionEvent event) 
    {
	if (jtf != null) {
	    jtf.setText("");
	    jtf.grabFocus();
	}
    }

    public void setJTextField(JTextField newValue)
    {
	jtf = newValue;
    }
}
