/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.event;

import xnap.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Maps a keystroke to an action.
 */
public class KeyAction extends AbstractAction {
    
    // --- Data Field(s) ---

    private AbstractAction ac;
    private JComponent jc;

    // --- Constructor(s) ---

    public KeyAction(AbstractAction ac, KeyStroke k, JComponent jc)
    {
	this.ac = ac;
	this.jc = jc;

	jc.getInputMap().put(k, ac);
	jc.getActionMap().put(ac, ac);
    }

    // --- Method(s) ---

    public void actionPerformed(ActionEvent e) 
    {
	ac.actionPerformed(new ActionEvent(jc, 0, ""));
		
	if (jc instanceof JTable) {
	    JTable jta = (JTable)jc;

	    int i = jta.getSelectionModel().getMaxSelectionIndex();
	    if (i == jta.getRowCount() - 1) {
		jta.getSelectionModel().setSelectionInterval(0, 0);
	    }
	    else if (i != -1 && i < jta.getRowCount() - 1) {
		jta.getSelectionModel().setSelectionInterval(i + 1, i + 1);
	    }
	    else {
		jta.clearSelection();
	    }
	}
    }
    
}

