/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.theme;

import xnap.gui.FontChooserDialog;
import xnap.gui.ThemeManager;
import xnap.gui.util.GUIHelper;

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;

public class CustomTheme extends Theme {

    //--- Constant(s) ---

    //--- Data field(s) ---    

    //--- Constructor(s) ---

    public CustomTheme()
    {
	super("Custom");
    }

    //--- Method(s) ---

    public boolean isConfigurable()
    {
	return true;
    }

    public Font getFont()
    {
	return GUIHelper.getFont("customTheme");
    }

    public Object[] getProperties()
    {
	if (properties == null) {
	    properties = createProperties(new FontUIResource(getFont()));
	}
	return properties;
    }

    public void setFont(Font newValue)
    {
	GUIHelper.setFont("customTheme", newValue);
	properties = createProperties(new FontUIResource(getFont()));
    }

    public boolean showConfigurationDialog(Component parent)
    {
	Font f = FontChooserDialog.showDialog(parent, getFont());
	if (f != null) {
	    setFont(f);
	    return true;
	}

	return false;
    }

}
