/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.io;

import xnap.net.AutoDownload;
import xnap.net.IDownloadContainer;
import xnap.util.FileHelper;
import xnap.util.SearchFilter;
import xnap.util.StringHelper;

import java.io.*;

/**
 * Do not use this class anymore. Replaced by ResumeFile3.
 */
public class ResumeFile2 extends ResumeFile {
    
    // --- Constant(s) ---

    // --- Data Field(s) ---
    
    protected String finalFilename;

    // --- Constructor(s) ---

    public ResumeFile2(File file, long finalSize, SearchFilter.Data filterData)
    {
	super(file, finalSize, filterData);

	this.finalFilename = file.getName();

	/* this should be in a separate function, but we don't want to break
           serialization stuff, do we?  So clean this up in the next major
           ResumeFile version.  */
	SearchFilter filter = new SearchFilter(getFilterData());
	if (filter.getSearchText() == null
	    || filter.getSearchText().length() == 0) {
	    String name = FileHelper.name(getName());
	    filter.setSearchText(StringHelper.stripExtra(name));
	}
    }

    public ResumeFile2(ResumeFile file)
    {
	this(file, file.getFinalSize(), file.getFilterData());
    }
    
    // --- Method(s) ---

    /**
     * @see xnap.io.ResumeFile3
     */
    public IDownloadContainer createDownload()
    {
	//return new AutoDownload(this);
	return null;
    }

    public String getFinalFilename()
    {
	return finalFilename;
    }

    public void setFinalFilename(String newValue)
    {
	finalFilename = newValue;
    }

}
