/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.io;

import xnap.net.AutoDownload;
import xnap.net.IDownloadContainer;
import xnap.util.FileHelper;
import xnap.util.SearchFilterData;
import xnap.util.StringHelper;

import java.io.*;

/**
 * Beware, changing the signature of this class, breaks the resume repository.
 */
public class ResumeFile3 extends File implements Serializable {
    
    // --- Constant(s) ---

    // --- Data Field(s) ---
    
    protected SearchFilterData filterData;
    protected String finalFilename;
    protected long finalSize;

    // --- Constructor(s) ---

    public ResumeFile3(File file, long finalSize, SearchFilterData filterData)
    {
	super(file, "");

	this.finalFilename = file.getName();
	this.finalSize = finalSize;
	this.filterData = filterData;

	if (filterData.searchText == null 
	    || filterData.searchText.trim().length() == 0) {
	    guessSearchText();
	}
    }

    // --- Method(s) ---

    public IDownloadContainer createDownload()
    {
	return new AutoDownload(this);
    }

    public SearchFilterData getFilterData()
    {
	return filterData;
    }

    public String getFinalFilename()
    {
	return finalFilename;
    }

    public long getFinalSize()
    {
	return finalSize;
    }

    public void guessSearchText()
    {
	String name = FileHelper.name(getName());
	filterData.searchText = StringHelper.stripExtra(name);
    }

    public void setFinalFilename(String newValue)
    {
	finalFilename = newValue;
    }

}
