/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.net.event.*;
import xnap.util.*;

import java.util.*;

public abstract class AbstractCommunication {

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected transient StatusChangeSupport statusChange
	= new StatusChangeSupport(this);

    protected int status = 0;
    protected String response = null;

    //--- Constructor(s) ---

    //--- Method(s) ---

    public int getStatus()
    {
	return status;
    }

    public String getStatusText() {
	if (response == null)
	    return getStatusMsg(status);
	else
	    return response;
    }

    protected abstract String getStatusMsg(int index);

    public void addStatusChangeListener(StatusChangeListener l)
    {
	statusChange.addStatusChangeListener(l); 
    }

    public void fireStatusChange(int oldValue, int newValue, String message) 
    {
        statusChange.fireStatusChange(oldValue, newValue, message);
    }

    public void fireStatusChange(int oldValue, int newValue) 
    {
	fireStatusChange(oldValue, newValue, null);
    }

    public void removeStatusChangeListener(StatusChangeListener l) 
    {
        statusChange.removeStatusChangeListener(l);
    }

    /**
     * Sets a new status and notifies listeners.
     *
     * @param newResponse custom status message
     */
    protected void setStatus(int newValue, String newResponse)
    {
	response = newResponse;

	int oldValue = status;
        status = newValue;
	fireStatusChange(oldValue, newValue, getStatusText());
    }

    /**
     * Sets a new status and notifies listeners.
     */
    protected void setStatus(int newValue)
    {
	setStatus(newValue, null);
    }

}
