/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.XNap;
import xnap.net.event.StatusChangeListener;
import xnap.user.UserData2;
import xnap.util.LinkSpeed;

import java.util.ArrayList;

public class UserContainer implements IUser {

    //--- Data field(s) ---

    protected ArrayList users = new ArrayList();
    protected IUser preferredUser = null;

    //--- Constructor(s) ---
    
    public UserContainer() 
    {
    }
    
    //--- Method(s) ---

    public synchronized void add(IUser u)
    {
	users.add(u);
    }

    public synchronized void addStatusChangeListener(StatusChangeListener l)
    {
    }

    public synchronized void clear()
    {
	preferredUser = null;
	users.clear();
    }

    public IBrowse getBrowse()
    {
	return null;
    }

    public String getCategory()
    {
	return (preferredUser != null) ? preferredUser.getCategory() : "";
    }

    public String getClientInfo()
    {
	return (preferredUser != null) ? preferredUser.getClientInfo() : "";
    }

    public String getComment()
    {
	return "";
    }

    public UserData2 getData()
    {
	return null;
    }
    
    public int getFileCount()
    {
	// FIX ME: return total?
	return 0;
    }

    public String getHost()
    {
	return (preferredUser != null) ? preferredUser.getHost() : "";
    }

    public void setCategory(String newValue)
    {
    }

    public void setComment(String newValue)
    {
    }

    public int getLocalDownloadCount()
    {
	return 0;
    }

    public synchronized void modifyLocalDownloadCount(int relative)
    {
    }

    public void setLocalDownloadCount(int newValue)
    {
    }

    public int getLocalUploadCount()
    {
	return 0;
    }

    public synchronized void modifyLocalUploadCount(int relative)
    {
    }

    public void setLocalUploadCount(int newValue)
    {
    }

    public int getMaxDownloads()
    {
	return 0;
    }

    public int getMaxUploads()
    {
	return 0;
    }
    
    public void setChatIgnored(boolean newValue)
    {
    }

    public void setMaxDownloads(int newValue)
    {
    }

    public void setMaxUploads(int newValue)
    {
    }

    public synchronized int getLinkSpeed()
    {
	if (preferredUser != null) {
	    return preferredUser.getLinkSpeed();
	}
	else {
	    return LinkSpeed.UNKNOWN;
	}	
    }

    public synchronized IUser[] getUsers()
    {
	IUser[] array = new IUser[users.size()];
	System.arraycopy(users.toArray(), 0, array, 0, array.length);
	return array;
    }

    public synchronized String getName()
    {
	if (preferredUser != null) {
	    return preferredUser.getName();
	}
	else {
	    return users.size() + " " + XNap.tr("users");
	}
    }

    public IChannel getPrivateChannel()
    {
	return null;
    }

    public boolean isActionSupported(Class actionClass)
    {
	return false;
    }

    public boolean isChatIgnored()
    {
	return false;
    }

    public boolean isRelated(int relation)
    {
	return false;
    }

    public boolean isTemporary()
    {
	return true;
    }

    public synchronized void remove(IUser u)
    {
	users.remove(u);
    }

    public synchronized void removeStatusChangeListener(StatusChangeListener l) 
    {
    }

    public synchronized void show(IUser u)
    {
	preferredUser = u;
    }

    public String toString()
    {
	return getName();
    }

    public int getStatus()
    {
	return IUser.STATUS_OFFLINE;
    }

    public String getStatusText()
    {
	return STATUS_MSGS[getStatus()];
    }

    public boolean isBanned()
    {
	return false;
    }

    public boolean isFriend()
    {
	return false;
    }

    public boolean isIgnored()
    {
	return false;
    }

    public void setTemporary(boolean newValue)
    {
    }

}
