/*
 * 03/30/2001
 *
 * PingMessage.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import java.io.IOException;
//  import ziga.io.DataOutputStream;

/**
 *
 * @version 0.1 04/12/2001
 * @author Frederik Zimmer
 */

public class PingMessage extends Message 
{
    private static final int PAYLOAD_LENGTH = 0;

    public PingMessage() 
    {
	super(DescriptorHeader.PING, PAYLOAD_LENGTH);
	setTTL((byte) 5);
    }
	
    public PingMessage(DescriptorHeader header) 
	throws InvalidMessageException 
    {
	super(header);
	if (header.payloadLength != PAYLOAD_LENGTH) {
	    throw new InvalidMessageException("Payload-length too high");
	}
    }	
}
