/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.cmdl.Console;
import xnap.plugin.nap.net.User;
import xnap.util.QuotedStringTokenizer;

public class WhowasResponseMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 605;

    //--- Data Field(s) ---

    public String nick;
    public String userLevel;
    public long lastSeen;

    //--- Constructor(s) ---

    public WhowasResponseMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 3);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	nick = t.nextToken();
	userLevel = t.nextToken();
	lastSeen = Long.parseLong(t.nextToken());
    }

    public void received()
    {

	User u = server.getUser(nick);
	u.setLastSeen(lastSeen);
	u.setLevel(userLevel);

	StringBuffer sb = new StringBuffer();
	sb.append("server: ");
	sb.append(server);
	sb.append("\nuser: ");
	sb.append(nick);
	sb.append("\nuser level: ");
	sb.append(userLevel);
	sb.append("\nlast seen: ");
	sb.append(lastSeen);

	Console.getInstance().println(sb.toString());
    }

}
