/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import java.util.*;
import org.apache.log4j.Logger;

public class FiniteStateMachine
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static Logger logger = Logger.getLogger(FiniteStateMachine.class);

    private String description;
    private State state;
    private Hashtable successorsByState;

    //--- Constructor(s) ---

    public FiniteStateMachine(State initialState, Hashtable successorsByState)
    {
	this.state = initialState;
	this.successorsByState = successorsByState;
    }

    public FiniteStateMachine(State initialState)
    {
	this(initialState, new Hashtable());
    }

    //--- Method(s) ---

    public void addState(State state, HashSet successors)
    {
	successorsByState.put(state, new HashSet(successors));
    }

    public boolean canSwitch(State oldState, State newState)
    {
	HashSet successors = (HashSet)successorsByState.get(oldState);
	return (successors != null) ? successors.contains(newState) : false;
    }

    public boolean canSwitch(State newState)
    {
	return canSwitch(getState(), newState);
    }

    public synchronized String getDescription()
    {
	return description;
    }

    public synchronized State getState()
    {
	return this.state;
    }

    /**
     * 
     */
    public synchronized void setState(State newState, String description) 
    {
	if (canSwitch(newState)) {
	    this.state = newState;
	    this.description = ((description != null) ? description 
				: state.getDescription());
	}
	else {
	    throw new IllegalStateException();
	}
    }

    public synchronized void setState(State newState) 
    {
	setState(newState, null);
    }

    //--- Static Method(s) ---    
    
    public static Hashtable createStateTable(State[][] table)
    {
	Hashtable stateTable = new Hashtable();

	for (int i = 0; i < table.length; i++) {
	    HashSet set = new HashSet();
	    State[] row = table[i];
	    for (int j = 1; j < row.length; j++) {
		set.add(row[j]);
	    }
	    stateTable.put(row[0], set);
	}

	return stateTable;
    }

}
