/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.cmdl.*;
import xnap.net.*;
import xnap.net.event.*;
import xnap.util.event.*;
import xnap.util.Formatter;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;
import org.apache.log4j.Logger;

/**
 * Provides transfer logging support in common logging file format that can
 * be evaluated by webalizer.
 */
public class TransferLogger {

    //--- Constant(s) ---

    public static String[] MONTHES = {
	"Jan", "Feb", "Mar", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep",
	"Oct", "Nov", "Dec"
    };

    //--- Data field(s) ---

    //protected static Logger logger = Logger.getLogger(TransferQueue.class);

    private BufferedWriter out = null;
    private String filename = null;

    //--- Constructor(s) ---

    public TransferLogger(String filename) throws IOException
    {
	setFilename(filename);
    }

    //--- Method(s) ---

    public void close()
    {
	try {
	    if (out != null) {
		out.close();
	    }
	}	    
	catch (IOException e) {
	}
    }

    public void setFilename(String filename) throws IOException
    {
	if (!filename.equals(this.filename)) {
	    this.filename = filename;
	    close();
	    out = new BufferedWriter(new FileWriter(filename, true));
	}
    }

    public void write(ITransferContainer t) throws IOException
    {
	IUser u = t.getUser();

	StringBuffer sb = new StringBuffer();
	String server = u.getHost();
	sb.append(server != null && server.length() > 0 ? server : "-");
	sb.append(" - \"");
	sb.append(mangleUsername(u.getName()));
	sb.append("\" [");
	Date d = new Date();
	sb.append((new SimpleDateFormat("dd/")).format(d));
	sb.append(MONTHES[Calendar.getInstance().get(Calendar.MONTH)]);
	sb.append((new SimpleDateFormat("/yyyy:HH:mm:ss z")).format(d));
	sb.append("] \"");
	sb.append(t instanceof IDownloadContainer ? "GET " : "PUT ");
	File f = t.getFile();
	//sb.append(f != null ? URLEncoder.encode(f.getAbsolutePath()) : "-");
	sb.append(f != null 
		  ? StringHelper.replaceAll(f.getAbsolutePath(), " ", "%20") 
		  : "-");
	sb.append("\" ");
	sb.append(t.getStatus() == ITransferContainer.STATUS_SUCCESS
		  ? HttpURLConnection.HTTP_OK
		  : HttpURLConnection.HTTP_BAD_REQUEST);
	sb.append(" ");
	sb.append(f != null ? f.length() : 0);
	// we don't have a referrer
	sb.append(" - ");
	server = u.getClientInfo();
	if (server != null) {
	    sb.append("\"");
	    sb.append(server);
	    sb.append("\"");
	}
	else {
	    sb.append("-");
	}
	
	out.write(sb.toString());
	out.newLine();
	out.flush();
    }     

    // webalizer doesn't like usernames containing brackets
    private String mangleUsername(String name)
    {
	name = StringHelper.replaceAll(name, "[", "%5B");
	name = StringHelper.replaceAll(name, "]", "%5D");

	return name;
    }

}
