/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util.audio;

import xnap.*;

import java.net.*;
import java.io.*;

public class AudioSupport
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static AudioPlayer player = null;
    private static String playerType = "";

    public static String[][] PLAYERS = {
	{ "jmf", "Java Media Player", "" },
	{ "xmms", "XMMS", "xmms" },
	{ "noatun", "Noatun", "" },
	//{ "winamp", "WinAMP", "C:\\Programme\\Winamp\\Winamp.exe" },
	{ "other", XNap.tr("Other"), "" },
    };

    //--- Constructor(s) ---

    private AudioSupport() 
    {
    }

    //--- Method(s) ---

    public static synchronized AudioPlayer getInstance(String type, 
						       String command)
    {
	if (player != null) {
	    if (type.equals(playerType))
		return player;
	    else
		player.stop();
	}

	if (type.equals("jmf")) {
	    return new JMFPlayer();
	}
	else if (type.equals("xmms")) {
	    return new XMMSPlayer(command);
	}
	else if (type.equals("noatun")) {
	    return new NoatunPlayer("Noatun");
	}
	else {
	    return new AudioPlayer(command);
	}
    }
}
