/*
 * gnuavi.h
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GNUAVI_H__
#define __GNUAVI_H__

#define gv_u32	unsigned int
#define gv_u16	unsigned short
#define gv_byte	unsigned char

#define GV_RIFF	0x52494646		/* RIFF */
#define GV_AVI	0x41564920		/* AVI  */
#define GV_LIST	0x4C495354		/* LIST */
#define GV_hdrl	0x6864726C		/* hdrl */
#define GV_avih	0x61766968		/* avih */
#define GV_STRL	0x7374726C		/* strl */
#define GV_strh	0x73747268		/* strh */
#define GV_strf 0x73747266		/* strf */
#define GV_movi	0x6D6F7669		/* movi */
#define GV_AUDS	0x61756473		/* auds */
#define GV_VIDS	0x76696473		/* vids */
#define GV_FRAM	0x30306462		/* 00db */
#define GV_SMPL	0x30317762		/* 01wb */


int gv_read4byte(gv_u32 *ret, FILE *fp);
int gv_read2byte(gv_u16 *ret, FILE *fp);

typedef struct {
	gv_u32	id;		/* 4 chars */
	gv_u32	size;
} gv_atom;

typedef struct {
	gv_u32 id;
	gv_u32 size;
	/* */
	unsigned char *data;
} gv_avi_movi;

typedef struct {
	gv_u32 	id;
	gv_u32	size;
	gv_u32	us_pf;		/* microseconds per frame */
	gv_u32	bps;		/* bytes per second */
	gv_u32	pad_gran;
	gv_u32	flags;
	gv_u32	frames;
	gv_u32	init_fr;
	gv_u32	streams;
	gv_u32	buf_size;
	gv_u32	width;
	gv_u32	height;
	gv_u32	scale;
	gv_u32	rate;
	gv_u32	start;
	gv_u32	length;
} gv_avi_avih;

typedef struct {
	gv_u32	id;
	gv_u32	size;
	gv_u32	type;
	gv_u32	fcc_handler;
	gv_u32	flags;
	gv_u32	priority;
	gv_u32	init_fr;
	gv_u32	scale;
	gv_u32	rate;
	gv_u32	start;
	gv_u32	length;
	gv_u32	buf_size;
	gv_u32	quality;
	gv_u32	sample_size;
} gv_avi_vid_strh, gv_avi_snd_strh, gv_avi_strh;

typedef struct {
	gv_u32	id;
	gv_u32	size;
	gv_u32	q_size;
	gv_u32	width;
	gv_u32	height;
	gv_u16	planes;
	gv_u16	bit_cnt;
	gv_u32	comp;
	gv_u32	image_size;
	gv_u32	xpels_meter;
	gv_u32	ypels_meter;
	gv_u32	num_colors;
	gv_u32	imp_colors;
} gv_avi_vid_strf;

typedef struct {
	gv_u32	id;
	gv_u32	size;
	gv_u16	format;
	gv_u16	channels;
	gv_u32	rate;
	gv_u32	average_bps;
	gv_u16	blockalign;
	gv_u16	sample_size;
} gv_avi_snd_strf;

/* avi video header */
typedef struct {
	gv_u32	id;
	gv_u32	size;
	gv_u32	type;
	gv_avi_vid_strh strh;
	gv_avi_vid_strf strf;
} gv_avi_vid;

/* avi sound header */
typedef struct {
} gv_avi_snd;

typedef struct {
	gv_avi_strh strh;
	void *strf;
} gv_stream_hdr;

typedef struct {
	gv_avi_avih avih;
	gv_avi_vid_strh	vid_strh;
	gv_avi_vid_strf	vid_strf;
	gv_avi_snd_strh	snd_strh;
	gv_avi_snd_strf	snd_strf;
	gv_stream_hdr *str;
} gv_avi_hdrl;

/*
 */
typedef struct {
	gv_u32	id;
	gv_u32	size;
	gv_u32	type;
	gv_u32	list_id;
	gv_u32	list_size;
	gv_u32	list_type;
	/* */
	gv_avi_hdrl	hdrl;
	gv_avi_movi	movi;
	/* */
	long d_pos;		/* data position */
	long f_pos;		/* file pointer position */
	FILE *fp;
	FILE *fp_snd;
} gv_avi;

#define gv_swap2byte(n) (n = \
		((gv_u16)n >> 8) | ((gv_u16)n << 8))
#define gv_swap4byte(n) (n = \
		(n >> 24) | (n << 24) | ((n >> 8)&0x0000FF00) | ((n << 8)&0x00FF0000))

gv_avi *gv_read_header (FILE *fp, FILE *fp_snd);

int gv_get_frame_raw (gv_avi *avi, unsigned char *buf, int pad);
int gv_get_frame_24toX (gv_avi *avi, unsigned char *buf, int pad, int bits);
int gv_get_frame_15to16 (gv_avi *avi, unsigned char *buf, int pad);
#define gv_get_frame_24to16(a,b,c) gv_get_frame_24toX(a,b,c,16)
#define gv_get_frame_24to15(a,b,c) gv_get_frame_24toX(a,b,c,15)
int gv_get_frame_15to24 (gv_avi *avi, unsigned char *buf, int pad);

gv_stream_hdr *gv_video_stream (gv_avi *, int);
gv_stream_hdr *gv_sound_stream (gv_avi *, int);
void gv_reset (gv_avi *);
void gv_skip_frame (gv_avi *);
int gv_read_id (gv_u32 *n, FILE *fp);

#endif /* __GNUAVI_H__ */
