#!/bin/sh

version=""

arg=$*


    if [ -z "$*" ]; then
    ##if zekr is called with "-workspace <dir>" option the following code is not executed.
    ##Is it a bug?!
#######
    # Load default settings from the user's configuration file.
    ZEKR_WORKSPACE=~/.zekr

    ZEKR_CONF_FILE=${ZEKR_WORKSPACE}/zekrrc-debian
    if [ ! -f "${ZEKR_CONF_FILE}" ]; then
        mkdir -p ${ZEKR_WORKSPACE}
        cp /etc/zekr/zekrrc "${ZEKR_CONF_FILE}"
    fi
    . ${ZEKR_CONF_FILE}
#######


    if [ ! -f ${ZEKR_WORKSPACE}/${version}.debian-lock ]; then
    #The following code is executed once after each version upgrade.
#####
    ##if zekr is called with "-workspace <dir>" option the following code is not executed.
    ##Is it a bug?!
        if [ -z "$*"  ]; then
    #       run -clean config 1>/dev/null
    #       run -clean index-me 1>/dev/null
            rm ${ZEKR_WORKSPACE}/*debian-lock -f
            touch ${ZEKR_WORKSPACE}/${version}.debian-lock
        fi
#####
    fi


    ####
    if [ ! "${ZEKR_WARNINGS}" = "disable" ]; then
        MEQRN=1
        if [ ! -e /usr/share/fonts/truetype/ttf-me_quran/me_quran_volt_newmet.ttf ]; then
            MEQRN=0
            zenity --warning \
              --title="ttf-me-quran is not installed." \
              --text="Uthman-Taha experimental theme cannot be used.\nInstall ttf-me-quran to enable Uthman-Taha theme."
 
        fi
        if [ "$MEQRN" -eq 0 ]; then
        

           zenity --question \
             --title="Show Warning messages Next Time" \
             --text="Do you want to leave warning message enabled?"

            if [ $? -eq 1 ]; then
                sed 's/ *ZEKR_WARNINGS.*=.*/ZEKR_WARNINGS=disable/' -i "${ZEKR_CONF_FILE}"
            fi
        fi
    fi
    ####

fi

# using eclipse's method for setting ZEKR_JAVA_HOME
# If the user has not set ZEKR_JAVA_HOME, cycle through our list of compatible VM's
# and pick the first one that exists.
if [ -z "${ZEKR_JAVA_HOME}" -a ! -n "${ZEKR_JAVA_CMD}" ]; then
#    echo "searching for compatible vm..."
    javahomelist=`cat /etc/zekr/java_home  | grep -v '^#' | grep -v '^$' | while read line ; do echo -n $line ; echo -n ":" ; done`
    OFS="$IFS"
    IFS=":"
    for ZEKR_JAVA_HOME in $javahomelist ; do
#        echo -n "  testing ${ZEKR_JAVA_HOME}..."
        if [ -x "${ZEKR_JAVA_HOME}/bin/java" ]; then
#            export ZEKR_JAVA_HOME
#            echo "found"
            break
#        else
#            echo "not found"
        fi
    done
    IFS="$OFS"
fi

# If we don't have a ZEKR_JAVA_HOME yet, we're doomed.
if [ -z "${ZEKR_JAVA_HOME}" -a ! -n "${ZEKR_JAVA_CMD}" ]; then
    zenity --error \
        --title="Could not launch Zekr" \
        --text="A suitable Java Virtual Machine for running the Zekr could not be located."
    exit 1
fi

# Set ZEKR_JAVA_CMD from ZEKR_JAVA_HOME
if [ -n "${ZEKR_JAVA_HOME}" -a -z "${ZEKR_JAVA_CMD}" ]; then
    ZEKR_JAVA_CMD="$ZEKR_JAVA_HOME/bin/java"
fi

run () {
MAIN_CLASS=net.sf.zekr.ZekrMain
JRE_OPT=-Djava.library.path=/usr/lib/jni/
CLASS_PATH=/usr/share/java/log4j-1.2.jar:/usr/share/java/swt.jar:/usr/share/java/commons-collections3.jar:/usr/share/java/commons-codec.jar:/usr/share/java/commons-configuration.jar:/usr/share/java/commons-lang.jar:/usr/share/java/commons-io.jar:/usr/share/java/commons-logging.jar:/usr/share/java/velocity.jar:/usr/share/java/lucene-highlighter.jar:/usr/share/java/lucene-core.jar:/usr/share/java/lucene-snowball.jar:/usr/share/java/lucene-memory.jar:/usr/share/java/jl.jar:/usr/share/java/basicplayer.jar:/usr/share/java/tritonus_share.jar:/usr/share/java/jorbis.jar:/usr/share/java/jogg.jar:/usr/share/java/jspeex.jar:/usr/share/java/mp3spi.jar:/usr/share/java/vorbisspi.jar:dist/zekr.jar:
VM_ARGS="-Xms10m -Xmx80m -Djava.net.preferIPv4Stack=true"

"$ZEKR_JAVA_CMD" $VM_ARGS -cp "$CLASS_PATH" $JRE_OPT $MAIN_CLASS $*
}

DIR_NAME=`dirname $0`
cd $DIR_NAME
cd ../share/zekr/

run $*
exit 0

