/*name and version number:@(#)linuxif.h	1.13*/
/*date of get: 		  11/24/03 14:46:49*/
/*date of delta:	  02/20/01 19:05:19*/
/****************************************************************
File :  linuxif.h
Description :
	Contains the interface functions for Linux

Procedures Contained :

****************************************************************/
/****************************************************************
MRS changes
- support for all kernel versions post 2.2
- return value consistency for no compiler warnings

Copyright (C) 1999, 2000, 2001 Lucent Technologies Inc.
Copyright (C) 2001, 2002, 2003 Agere Systems Inc. All rights reserved.

****************************************************************/

#include <linux/spinlock.h>

#define LT_COUNTRY_ID	0x19
#ifdef USE_TTYS14

#define LT_SERIAL_PORT_DEFNS			        \
	/* UART CLK   PORT IRQ     FLAGS         */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS0 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS1 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS2 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS3 */     \
	{ 0, BASE_BAUD, 0x000, 0, 0 }, 	/* ttyS4 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS5 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS6 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS7 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS8 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS9 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS10 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS11 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS12 */	\
	{ 0, BASE_BAUD, 0x000, 0, 0 },	/* ttyS13 */	\
	{ 0, BASE_BAUD, 0x000, 0, ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST },	/* ttyS14 */	
#else
#define LT_SERIAL_PORT_DEFNS			        \
	/* UART CLK   PORT IRQ     FLAGS         */	\
	{ 0, BASE_BAUD, 0x000, 0, ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST },	/* ttyS14 */	
#endif


#ifdef PORT_MAX
#undef PORT_MAX
#endif

/* #if (LINUX_VERSION_CODE >= 0x20400) deprecated*/
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
#define PORT_LTMODEM PORT_16550A
#else
#define PORT_LTMODEM 15
#endif
#define PORT_MAX     15
#define LT_KER_24
#else
#define PORT_LTMODEM 10
#define PORT_MAX     10
#endif
#define TRUE 1
#define FALSE 0

typedef unsigned char byte ;
typedef unsigned short word ;
typedef unsigned long dword ;
typedef int BOOL;

#define asstr2(x) #x
#define asstr(x) asstr2(x)

#ifndef LTNUMBER
#define LTNUMBER 0
#endif

#if LTNUMBER > 0
#define ltstringcat(x)	"ltserial" #x
#define ltserialstring	 ltstringcat(LTNUMBER)
// need to do this manually since
/* #define GetLtModemInterface GetLt ## LTNUMBER ## ModemInterface */
// doesnt do a translation of LTNUMBER first
// currently only 4 instances
#if LTNUMBER == 1
#define SetLtModemInterface SetLt ## 1 ## ModemInterface
#define GetLtModemInterface GetLt ## 1 ## ModemInterface
#elif LTNUMBER == 2
#define SetLtModemInterface SetLt ## 2 ## ModemInterface
#define GetLtModemInterface GetLt ## 2 ## ModemInterface
#elif LTNUMBER == 3
#define SetLtModemInterface SetLt ## 3 ## ModemInterface
#define GetLtModemInterface GetLt ## 3 ## ModemInterface
#elif LTNUMBER == 4
#define SetLtModemInterface SetLt ## 4 ## ModemInterface
#define GetLtModemInterface GetLt ## 4 ## ModemInterface
#else
#error max of 4 extra modules are currently configured in the source
#endif

#else
#define ltserialstring	 "ltserial"
#endif

/* #if (LINUX_VERSION_CODE >= 0x20400) deprecated */
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
#if LTNUMBER > 0
#define lt_rs_interruptstring "lt" asstr(LTNUMBER) "_rs_interrupt"
#if 0
//#define lt_rs_interrupt lt ## LTNUMBER ## _rs_interrupt
#if LTNUMBER == 1
#define lt_rs_interrupt lt ## 1 ## _rs_interrupt
#elif LTNUMBER == 2
#define lt_rs_interrupt lt ## 2 ## _rs_interrupt
#elif LTNUMBER == 3
#define lt_rs_interrupt lt ## 3 ## _rs_interrupt
#elif LTNUMBER == 4
#define lt_rs_interrupt lt ## 4 ## _rs_interrupt
#elif LTNUMBER > 4
#error max of 4 extra modules are currently configured in the source
#endif
#endif

#else
#define lt_rs_interruptstring "lt_rs_interrupt"
#endif
#else
#define lt_rs_interruptstring "lt_rs_interrupt"
#endif

struct ltmodem_ops
{
	int (* detect_modem)(void *pltmodem_res, int passnumber);
	void (* ASMLINKAGE init_modem)(void);
	int (* ASMLINKAGE PortOpen)(void);
	void (* ASMLINKAGE PortClose)(void);
	int (* ASMLINKAGE read_vuart_register)(int offset);
	void (* ASMLINKAGE write_vuart_register)(int offset, int value);
	int (* ASMLINKAGE app_ioctl_handler)(unsigned int cmd, unsigned long arg);
	byte(* ASMLINKAGE dsp_isr)(void);
	word (* ASMLINKAGE read_buffer)( byte *data, word size );
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
	spinlock_t *modem_lock;
#endif
};

struct ltmodem_res
{
	word BaseAddress;
	byte Irq;
};

struct lt_pci_dev_info
{
	unsigned short	irq;
	unsigned short	vendor;
	unsigned short	device;
	unsigned short	subsystem_vendor;
	unsigned short	subsystem_device;
	unsigned short	devfn;
	unsigned char	bus_num;
	unsigned long 	Base_Address[6];
};	

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
extern int GetLtModemInterface(void *mdmdata);
extern int SetLtModemInterface(int state);
#endif
extern ASMLINKAGE void dp_regwrite_nonint ( byte reg, byte value );
extern ASMLINKAGE byte dp_regread_nonint ( byte reg );
extern ASMLINKAGE int modemPortOpen ( void );
extern ASMLINKAGE void modemPortClose ( void );

#define IOCTL_MODEM_APP_1	_IOR(62,41,char *)
#define IOCTL_MODEM_APP_2	_IOR(62,42,char *)
#define IOCTL_MODEM_APP_3	_IOR(62,43,char *)
#define IOCTL_MODEM_APP_4	_IOR(62,44,char *)
#define IOCTL_MODEM_APP_5	_IOR(62,45,char *)
#define IOCTL_MODEM_APP_6	_IOR(62,46,char *)
#define IOCTL_MODEM_APP_7	_IOR(62,47,char *)
#define IOCTL_MODEM_APP_8	_IOR(62,48,char *)

